#include <formatio.h>
#include <stdlib.h>
#include "gwsfg83u.h"
#include "gwsfg830.h"
#include <userint.h>        
/* Needed if linking in external compiler; harmless otherwise */
#include <cvirte.h>

/*======================== Global Variabe Definition ========================*/ 
ViInt16 panelHand[5];
ViStatus uirErr;
ViInt16 uirCode;
ViInt32 instrumentHandle;

/*====================== Utility Function Declarations ======================*/ 
int abortApplication (void);

static int panel3, panel2, panel1, panelMain;

/*****************************************************************************/
/*=== Begin UIR SOURCE CODE =================================================*/
/*****************************************************************************/

int main (int argc, char *argv[])
{
    if (InitCVIRTE (0, argv, 0) == 0)   /* Needed if linking in external compiler; 
                                           harmless otherwise */
        return -1;  /* out of memory */
    if ((panelHand[PANEL_MAIN] = LoadPanel (0, "gwsfg83u.uir", PANEL_MAIN)) < 0)
        return -1;
    if ((panelHand[PANEL_3] = LoadPanel (panelHand[PANEL_MAIN], "gwsfg83u.uir", 
            PANEL_3)) < 0)
        return -1;
    if ((panelHand[PANEL_2] = LoadPanel (panelHand[PANEL_MAIN], "gwsfg83u.uir",  
            PANEL_2)) < 0)
        return -1;
    if ((panelHand[PANEL_1] = LoadPanel (panelHand[PANEL_MAIN], "gwsfg83u.uir",  
            PANEL_1)) < 0)
        return -1;
    DisplayPanel (panelHand[PANEL_MAIN]);
    DisplayPanel (panelHand[PANEL_1]);
    uirCode = RunUserInterface ();
    return 0;
}

/*****************************************************************************/ 
int CVICALLBACK initPanel (int panel, int control, int event,
        void *callbackData, int eventData1, int eventData2)
{
    int IDQuery, reset;
    ViChar resourceName[256];  
    
    switch (event) {
        case EVENT_COMMIT:
            switch (control) {
                case PANEL_1_CONTINUE:
                    SetCtrlVal (panelHand[PANEL_1], PANEL_1_CONTINUE, 1);
                    GetCtrlVal (panelHand[PANEL_1], PANEL_1_RESOURCE_NAME, resourceName);
                    GetCtrlVal (panelHand[PANEL_1], PANEL_1_ID_QUERY, &IDQuery);
                    GetCtrlVal (panelHand[PANEL_1], PANEL_1_RESET_DEVICE, &reset);
            
                    if ((uirErr = gwsfg830_init (resourceName , IDQuery, reset, &instrumentHandle))<0)
                        abortApplication ();
            
                    DisplayPanel (panelHand[PANEL_2]);
                break;
            }   
            break;
        case EVENT_RIGHT_CLICK:
            switch (control) {
                case PANEL_1_RESOURCE_NAME:
                    MessagePopup ("Control Help",
                        "Specifies the interface and address of the device.\n\n"
                        "Interface Grammar:\n GPIB[board]::primary address[::secondary "
                        "address][::INSTR]");
                    break;
                case PANEL_1_ID_QUERY:
                    MessagePopup ("Control Help",
                        "Specifies if an ID Query is sent to the instrument\n during the "
                        "initialization procedure.\n\nValid Range:\nVI_OFF (0) - Skip "
                        "Query\nVI_ON  (1) - Do Query (Default Value)");
                    break;
                case PANEL_1_RESET_DEVICE:
                    MessagePopup ("Control Help",
                        "Specifies if the instrument is to be reset to its\n"
                        "power-on settings during the initialization procedure.\n\n"
                        "Valid Range:\n"
                        "VI_OFF (0) - Don't Reset\n"
                        "VI_ON  (1) - Reset Device (Default Value)");
                    break;
                case PANEL_1_CONTINUE:
                    MessagePopup ("Control Help", "Runs the opening session with instrument "
                        "and opens next panel.");
                    break;
                default:
                break;  
            }   
    }
    return 0;
}

/*****************************************************************************/ 
int CVICALLBACK acquirePanel (int panel, int control, int event,
        void *callbackData, int eventData1, int eventData2)
{
    int waveform;
    double frequency, amplitude, offset;
    ViString cmdArr[]={"","Sine Wave","Square Wave","Trianlge Wave","Ramp Wave",
                       "Arbitrary Wave"}; 
    
    switch (event) {
        case EVENT_COMMIT:
            switch (control) {
                case PANEL_2_CONTINUE_3:
                    GetCtrlVal (panelHand[PANEL_2], PANEL_2_WAVEFORM, &waveform);
                    GetCtrlVal (panelHand[PANEL_2], PANEL_2_FREQUENCY, &frequency);
                    GetCtrlVal (panelHand[PANEL_2], PANEL_2_AMPLITUDE, &amplitude);
                    GetCtrlVal (panelHand[PANEL_2], PANEL_2_OFFSET, &offset);
                    
                    if ((uirErr = gwsfg830_generateWaveform (instrumentHandle, waveform,
                         frequency,amplitude,offset))<0)
                       abortApplication();
                    
                    DisplayPanel(panelHand[PANEL_3]);
                    
                    SetCtrlVal (panelHand[PANEL_3], PANEL_3_WAVEFORM_I, cmdArr[waveform]);
                    SetCtrlVal (panelHand[PANEL_3], PANEL_3_FREQUENCY_I, frequency);
                    SetCtrlVal (panelHand[PANEL_3], PANEL_3_AMPLITUDE_I, amplitude);
                    SetCtrlVal (panelHand[PANEL_3], PANEL_3_OFFSET_I, offset);
                break;  
            }   
            break;
        case EVENT_RIGHT_CLICK:
            switch (control) {
                case PANEL_2_WAVEFORM:
                    MessagePopup ("Control Help", "Selects the output waveform to "
                        "be displayed.\n\n"
                        "Valid Range:\n"
                        "1 - Sine Wave(Default Value)\n"
                        "2 - Square Wave\n"
                        "3 - Triangle Wave\n"
                        "4 - Ramp Wave\n"
                        "5 - Arbitrary Wave");
                    break;
                case PANEL_2_FREQUENCY:
                    MessagePopup ("Control Help", "Selects frequency of generator output "
                        "in Hz.\n\n"
                        "Valid Range:\n"
                        "Sine,Square,Arbitrary is 0.01 Hz to 3.0E+7 Hz\n"
                        "Triangle,Ramp is 0.01 Hz to 1.0E+5 Hz\n\n"
                        "Default Value: 1000.0 Hz");
                    break;
                case PANEL_2_AMPLITUDE:
                    MessagePopup ("Control Help", "Selects constant voltage ac amplitude "
                        "in V.\n\n"
                        "Valid Range: 0.0E+0 V to 1.0E+1 V\n\n"
                        "Default Value: 1.0 V");
                    break;
                case PANEL_2_OFFSET:
                    MessagePopup ("Control Help", "Selects constant voltage dc level in V.\n\n"
                        "Valid Range: -5.0 V to 5.0E+0 V\n\n"
                        "Default Value: 0.0 V\n\n");
                    break;
                case PANEL_2_CONTINUE_3:
                    MessagePopup ("Control Help",
                        "Executes the function's settings and opens the next panel.");
                    break;

            }   
    }
    return 0;
}

/*****************************************************************************/ 
int CVICALLBACK displayPanel (int panel, int control, int event,
        void *callbackData, int eventData1, int eventData2)
{
    switch (event) {
        case EVENT_COMMIT:

            break;
        case EVENT_RIGHT_CLICK:
            switch (control) {
                case PANEL_3_WAVEFORM_I:
                    MessagePopup ("Control Help", "Displays the waveform read from the "
                        "instrument.");
                    break;
                case PANEL_3_FREQUENCY_I:
                    MessagePopup ("Control Help", "Displays the frequency read from the "
                        "instrument.");
                    break;
                case PANEL_3_AMPLITUDE_I:
                    MessagePopup ("Control Help", "Displays the amplitude read from the "
                        "instrument.");
                    break;
                case PANEL_3_OFFSET_I:
                    MessagePopup ("Control Help", "Displays the offset read from the "
                        "instrument.");
                    break;
                default:
                break;  
            }   
    }
    return 0;
}

/*****************************************************************************/ 
int CVICALLBACK Quit (int panel, int control, int event,
        void *callbackData, int eventData1, int eventData2)
{
    switch (event) {
        case EVENT_COMMIT:
            if ( (ConfirmPopup ("Exit Application", "Would you like to exit this "
                  "application?")) == 1) {
                gwsfg830_close (instrumentHandle);
                QuitUserInterface (uirCode);
            }
            break;
        case EVENT_RIGHT_CLICK:
            MessagePopup ("Control Help",
                  "Closes this session with instrument and closes the "
                  "application.");
            break;
    }
    return 0;
}

/*****************************************************************************/ 
int CVICALLBACK Back (int panel, int control, int event,
        void *callbackData, int eventData1, int eventData2)
{
    switch (event) {
        case EVENT_COMMIT:
            SetCtrlVal (panelHand[PANEL_2], PANEL_2_CONTINUE_3, 0);
            DisplayPanel (panelHand[PANEL_2]);
            break;
        case EVENT_RIGHT_CLICK:
            MessagePopup ("Control Help",
                  "Switches the application to the Acquisition Configuration panel.");
            break;
    }
    return 0;
}

/*****************************************************************************/ 
int CVICALLBACK Cancel (int panel, int control, int event,
        void *callbackData, int eventData1, int eventData2)
{
    switch (event) {
        case EVENT_COMMIT:
            if ((ConfirmPopup ("Exit Application", "Would you like to exit this "
                   "application?")) == 1) {
                QuitUserInterface (uirCode);
            }
            break;
        case EVENT_RIGHT_CLICK:
            MessagePopup ("Control Help",
                  "Closes this session with instrument and closes the application.");
            break;
    }
    return 0;
}

/*****************************************************************************/ 
int abortApplication (void)
{
    ViChar errorMessage[256], errBuffer[256];
    ViInt16 response;

    SetWaitCursor (0);
    gwsfg830_errorMessage(VI_NULL, uirErr, errorMessage);
    Fmt (errBuffer,"%s<The following error caused the application to fail:\n\n%s\n\n"
        "Attempting to Close Instrument Driver and Exit Application", 
        errorMessage);
    MessagePopup("ERROR!, Application Failed", errBuffer);
    
    if ((uirErr = gwsfg830_close (instrumentHandle)) < 0) {
        gwsfg830_errorMessage(VI_NULL, uirErr, errorMessage);
        Fmt (errBuffer, "%s<Application failed to close the Instrument Driver.\n\n"
            "%s\n\nExiting Application.", errorMessage);
        MessagePopup("ERROR!",errBuffer);
    }
    else 
        MessagePopup("Application Aborted","Instrument Driver Closed, Exiting Application.");
        
    QuitUserInterface (uirCode);
    exit (-1);
    
    return 0;
}

/*****************************************************************************/ 
void CVICALLBACK PanelHelp (int menuBar, int menuItem, void *callbackData,
        int panel)
{
    if (GetActivePanel () == (panelHand[PANEL_1])) MessagePopup ("Panel Help",
                  "This panel opens a session with the instrument.\nPerforms an identification query on the instrument\nResets the instrument to a known state.");
    if (GetActivePanel () == (panelHand[PANEL_2])) MessagePopup ("Panel Help",
                  "This panel sets and performs the instrument setting.\nPerforms an data reading from the instrument.");
    if (GetActivePanel () == (panelHand[PANEL_3])) MessagePopup ("Panel Help",
                  "This panel displays the data from the instrument.");
    if (GetActivePanel () == (panelHand[PANEL_MAIN])) MessagePopup ("Panel Help",
                  "This is a simple demo program using the gwfg830 instrument driver.\n"
                  "It initializes and optionally resets the instrument to a known state.\n"
                  "It then configures, and reads the data back from the instrument.\n");
}

/*****************************************************************************/
/*=== END UIR SOURCE CODE ===================================================*/
/*****************************************************************************/
